#ifndef _GRAPH_H_
#define _GRAPH_H_

#include <vcl.h>
#include <math.h>
#include "matrix.h"
#include <jpeg.hpp>

class Graph
  {
  private:

  Graphics::TBitmap *image;
  TCanvas *canvas;
  //dane (x,y,wielkosc,kolor)
  Matrix *matrix;
  //etykietki
  AnsiString *vec;

  double x_min;
  double x_max;
  //podzialka x
  double x_graduation;
  //polozenie znacznika na osi x
  double x_tick_position;
  double y_min;
  double y_max;
  double y_graduation;
  double y_tick_position;

  //przelozenie punktow na odleglosci
  double x_scale;
  double y_scale;

  //odstep wykresu od krawedzi plotna
  int border_offset;

  AnsiString GraphTitle, XAxis, YAxis;
  bool tags;
  bool dots;
  unsigned int tags_position;
  bool transparent_tags;

  //kasuje dane i wpisuje nowe
  void FromMatrix(Matrix & m, AnsiString * v);
  //dodaje dane
  void AddMatrix(Matrix & m, AnsiString * v);
  //dadaje etykietki
  void AddVec(AnsiString * v, unsigned int n);

  public:

  Graph();
  Graph(Graphics::TBitmap * img);
  ~Graph();

  void Init(Graphics::TBitmap * img);

  //dodaje opisy osi
  void SetLabels(AnsiString title, AnsiString x, AnsiString y);
  //ustawia wyswietlanie etykiet
  void SetTags(bool TagsVisible, unsigned int TagsPosition, bool TagsTransparent);
  //ustawia wyswietlania punktow
  void SetDots(bool DotsVisible);
  //ustawia zakres
  void SetRange(double xmin, double xmax, double ymin, double ymax);
  //ustawia podzialke(polozenie_podzialki_x,odleglosc_miedzy_podzialkami_x,...
  void SetScale(double xtick, double xscale, double ytick, double yscale);
  //zwraca zakres
  void GetRange(double* xmin, double* xmax, double* ymin, double* ymax);
  //zwraca podzialke
  void GetGraduation(double* xgrad, double* ygrad);

  //automatycznie centruje i skaluje
  void AutoScale();
  //wyswietla w prawidlowych proporcjach
  void Proportional();

  //rysuje bez dodawania danych
  void DrawCircle(int x, int y, int r, TColor color);
  void DrawFrameOnTop(int xmin, int xmax, int ymin, int ymax);
  void DrawPoint(double x, double y, int r, TColor color);
  void DrawTag(double x, double y, AnsiString label, int size, TColor color);
  void DrawTxt(double x, double y, AnsiString label, int size, TColor color);
  //czysci wykres
  void ClearGraph();

  //dodaje punkt
  void AddPoint(double x, double y, int r, TColor color);
  //kasuje punkty
  void ErasePoints();
  //rysuje punkty
  void DrawGraph();
  //rysuje osie
  void DrawAxes();
  //rysuje caly wykres
  void Plot();

  void Pan(double x, double y);
  void Zoom(int left, int right, int top, int bottom);
  void ZoomIn(int x, int y);
  void ZoomOut(int x, int y);

  void FromMatrix(Matrix & m, int r, TColor color, AnsiString * v);
  void AddMatrix(Matrix & m, int r, TColor color, AnsiString * v);

  //zapisuje jako jpg
  void ToFile(AnsiString filename);

  };

#endif