﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Neurall
{
    class Input
    {
        /*Wczytuje dane z pliku i umieszcza w liście Ar , ktorej poszczególne listy reprezentują cecy danego obiektu, 
        * zwraca ([0]) liczbę obiektów w pliku z danymi oraz liczbę ich cech([1])
        * Jesli wczytuje się plik do nauki to [1] jest liczbą cech +1 , czyli liczba określająca klasę
        */

        public static void Wczytaj(StreamReader sr, List<List<double>> Ar)
        {

            string s;


            string pp = @"[\s ]+";

            while (((s = sr.ReadLine()) != null))
            {
                s = s.Trim();
                
                string[] spodz = Regex.Split(s, pp);
                List<double> l1 = new List<double>();
                for (int i = 0; i < spodz.Length; i++)
                {

                    l1.Add(double.Parse(spodz[i].Replace(".", ",")));

                }
                Ar.Add(l1);
            }
        }


        //z wczytanych danyc htestowych wyodrębnia tabicę klas 
        public static int[][] Create_d(List<List<double>> Ar,int licz)
        {
            int[][] d = new int[Ar.Count][];
            for (int i = 0; i < Ar.Count; i++)
                d[i] = new int[licz];
            int indx = Ar[0].Count - licz;
            for (int i = 0; i < Ar.Count; i++)
            {
                for (int j = 0; j < licz; j++)
                {
                    d[i][j] = (int)Ar[i][indx+j];
                  
                }
            }
            return d;

        }


        public static void dodaj()
        {
            string nazw = @"E:\astro\MagDuch\26.04.09\NeuralN\dane\Error.txt";
            FileStream Fs = new FileStream(nazw, FileMode.Create, FileAccess.ReadWrite);
            StreamWriter Sw = new StreamWriter(Fs);
            StreamReader Rw = new StreamReader(Fs);
            for (int i = 0; i < 19227; i++)
            {
                Rw.ReadLine();

            }
            for (int i = 19227; i < 19999; i++)
            {
                Sw.WriteLine("19226 0.00303816479957241");
            }
            Sw.Close();
            Rw.Close();
            Fs.Close();
        }
        public static void Error_do_pl(StreamWriter str,List<double>E)
        {

                    for (int i = 0; i < E.Count; i++)
                    {
                        str.WriteLine(i.ToString() + " " + E[i].ToString().Replace(",", "."));
                    }

                }
                //string nazw = @"E:\astro\MagDuch\26.04.09\NeuralN\dane\" + nazwa;
                //FileStream Fs = new FileStream(nazw, FileMode.Create, FileAccess.ReadWrite);
                //treamWriter Sw = new StreamWriter(Fs);

                //Sw.Close();
               // Fs.Close();

            

        public static void AddBiasRemClass(List<List<double>> Ar,int licz) //usuwa ostatni wymiar(klasę) i zamiast niej dodaje -1 bias
        {
            foreach (List<double> row in Ar)
            {
                for (int j = 0; j < licz; j++)
                {
                    row.RemoveAt(row.Count - 1);
                    
                }
                row.Add(-1);
            }
        }

        public static void AddBias2RemClass(List<List<double>> Ar) //usuwa ostatni wymiar(klasę) i zamiast niej dodaje -1 bias
        {
            foreach (List<double> row in Ar)
            {
                row.RemoveAt(row.Count - 1);
                row.Add(-1);
                row.Add(1);
            }
        }


        public static void Arch(List<int> s,string str)
        {
            
            string[] txt2 = str.Split(new Char [] {','});
            for (int i = 0; i < txt2.Length; i++)
            {
                s.Add(int.Parse( txt2[i].Trim()));
            }
        }
        /* public static List<List<double>> normlist(List<List<double>> Ar)
         {
             List<List<double>> list = new List<List<double>>();
             foreach (List<double> row in Ar)
             {
                 double[] d = Neuron.norm(row.ToArray(), 100);
                 list.Add(d.ToList<double>());
             }
             return list;
         }*/

        public static void AddClass(List<List<double>> Ar, int [][] ll)
        {
            int licz = ll[0].Length;
            for (int i = 0; i < Ar.Count; i++)
            {
                for (int j = 0; j < licz; j++)
                {
                    Ar[i].Add(ll[i][j]);
                }

            }
        }

       

        public static void RemClass(List<List<double>> Ar,int licz)
        {
            foreach (List<double> row in Ar)
            {
                for (int j = 0; j < licz; j++)
                {
                    row.RemoveAt(row.Count - 1);

                }
            }
        }


        public static void AddBias(List<List<double>> Ar) //usuwa ostatni wymiar(klasę) i zamiast niej dodaje -1 bias
        {
            foreach (List<double> row in Ar)
            {

                row.Add(-1);
            }
        }


        public static void Randd(  List<List<double>> ll,int[][] dd,int kk)
        {
            int k;
            List<double> temp;
            List<double> temp2;
            int [] dte;
            Random rand1 = new Random((int)(System.Convert.ToInt32(System.DateTime.UtcNow.Millisecond+kk)));
            k = rand1.Next(0, ll.Count - 1);
            temp = ll[k];
            temp2 = ll[ll.Count - 1];
            ll.RemoveAt(ll.Count - 1);
            ll.RemoveAt(k);
            ll.Insert(k, temp2);
            ll.Add(temp);
            
            dte = dd[k];
            dd[k] = dd[ll.Count - 1];
            dd[ll.Count - 1] = dte;
            for (int i = ll.Count - 2; i >= 0; i--)
            {
                Random rand = new Random((int)(System.Convert.ToInt32(System.DateTime.UtcNow.Millisecond + kk+i))); ;
               k= rand.Next(0, i);
               temp = ll[k];
               temp2 = ll[i];
               if (i != k)
               {
                   ll.RemoveAt(i);

                   ll.RemoveAt(k);
                   ll.Insert(k, temp2);
                   ll.Insert(i, temp);
                  
                   dte = dd[k];
                   dd[k] = dd[i];
                   dd[i] = dte;
               }

            }
        
        }


        public static List<List<List<double>>> Randd2(List<List<double>> ll) //nie losuje juz 500 probki, ale dzieli ll na 10 klas i losuje 10 rozlacznych zbior/ow
        {
            int k;
            int h=0;
            List<double> temp;
            List<double> temp2;
            List<List<List<double>>> wynik = new List<List<List<double>>>();
            
            int il = (int)Math.Floor((double)ll.Count / 10);
            for (int i = 0; i < 9; i++)
            {
                List<List<double>> lis = new List<List<double>>();
                h = 0;
               
                while(1==1)
                {
                    h++;
                Random rand1 = new Random((int)(System.Convert.ToInt32(System.DateTime.UtcNow.Millisecond+3*h )));
                k = rand1.Next(0, ll.Count - 1);
                temp = ll[k];
                temp2 = ll[ll.Count - 1];
                ll.RemoveAt(ll.Count - 1);
                ll.RemoveAt(k);
                ll.Insert(k, temp2);
                //ll.Add(temp);
                lis.Add(temp);

               
                    if (h == il)
                        break;
                }
                wynik.Add(lis);

                 
          }
            List<List<double>> ls = new List<List<double>>();
            
            while (ll.Count>1)
            {
                Random rand1 = new Random((int)(System.Convert.ToInt32(System.DateTime.UtcNow.Millisecond  )));
                k = rand1.Next(0, ll.Count - 1);
                temp = ll[k];
                temp2 = ll[ll.Count - 1];
                ll.RemoveAt(ll.Count - 1);
                ll.RemoveAt(k);
                ll.Insert(k, temp2);
                //ll.Add(temp);
                ls.Add(temp);


            }
            
            wynik.Add(ls);


            return wynik;

        }













        public static List<List<double>> Randd3(List<List<double>> ll, int kk, int l)
        {
            int k;
            int h = 0;
            List<double> temp;
            List<double> temp2;
            List<List<double>> lis = new List<List<double>>();

            Random rand1 = new Random((int)(System.Convert.ToInt32(System.DateTime.UtcNow.Millisecond + kk)));
            k = rand1.Next(0, ll.Count - 1);
            temp = ll[k];
            temp2 = ll[ll.Count - 1];
            ll.RemoveAt(ll.Count - 1);
            ll.RemoveAt(k);
            ll.Insert(k, temp2);
            ll.Add(temp);
            lis.Add(temp);

            for (int i = ll.Count - 2; i >= 0; i--)
            {
                h++;
                Random rand = new Random((int)(System.Convert.ToInt32(System.DateTime.UtcNow.Millisecond + kk + i))); ;
                k = rand.Next(0, i);
                temp = ll[k];
                temp2 = ll[i];
                if (i != k)
                {
                    ll.RemoveAt(i);

                    ll.RemoveAt(k);
                    ll.Insert(k, temp2);
                    ll.Insert(i, temp);

                    lis.Add(temp);
                }
                if (h == l)
                    break;

            }
            return lis;

        }


        public static List<List<double>> ZbTreCross(List<List<double>> lea, List<List<double>> l1,List<List<double>> test)
        {

            int zn;
            double [] arr=new double[lea[0].Count];
            List<List<double>> wynik = new List<List<double>>();
           
           
            foreach (List<double> row in lea)
            {
                zn = 0;
                for(int i=0;i<l1.Count;i++)
                {
                    if (row[0] == l1[i][0] && row[1] == l1[i][1] && row[2] == l1[i][2])
                        zn = 1;
                         
                }
                if (zn == 0)
                    row.CopyTo(arr);
                    wynik.Add(arr.ToList<double>());
                    test.Add(arr.ToList<double>());
         
            }         
                          
            
           return wynik;

        }


    

       


        public static void Norm(int ob,List<List<double>> Ar)
        {
            List<double>[]  min = new List<double>[Ar[0].Count];
           List< double>[]  max = new List<double>[Ar[0].Count];
           double yy = 1.1;
           int o = Convert.ToInt32(Math.Ceiling(Ar.Count * Convert.ToDouble(ob) / 100)); 
            for (int i = 0; i < Ar[0].Count; i++)
            {
                min[i] = new List<double>();
                max[i] = new List<double>();
                
              
                for (int j = 0; j < Ar.Count; j++)
                {
                    min[i].Add(Ar[j][i]);
                    max[i].Add(Ar[j][i]);
                }
                min[i].Sort();
                max[i].Sort();

                min[i].Insert(0, min[i][o]);
                max[i].Insert(0,max[i][Ar.Count-o-1]);



                

                 for (int j = 0; j < Ar.Count; j++)
                {

                    Ar[j][i] = (Ar[j][i] - min[i][0]) / (max[i][0] - min[i][0]);

                } 

            }

        }


        public static void Stand(List<List<double>> Ar)
        {
            double[] avr = new double[Ar[0].Count];
            double[] odch = new double[Ar[0].Count];

            for (int i = 0; i < Ar[0].Count; i++)
            {
               
                for (int j = 0; j < Ar.Count; j++)
                {
                    avr[i] += Ar[j][i];
                }

                avr[i] = avr[i] / Ar.Count;
                
                for (int j = 0; j < Ar.Count; j++)
                {
                    odch[i] += ((Ar[j][i] - avr[i]) * (Ar[j][i] - avr[i]));

                }
                odch[i] = Math.Sqrt(odch[i] / (Ar.Count - 1));
                for (int j = 0; j < Ar.Count; j++)
                {
                    Ar[j][i] = (Ar[j][i] - avr[i]) / (odch[i]);
                }

            }

        }

        public static double Ape(List<List<double>> wyn,int licz)
        {
            double er = 0;
            for (int i = 0; i < wyn.Count; i++)
            {
                for (int j = 0; j < licz; j++)
                {
                    er += Math.Abs(wyn[i][j] - wyn[i][j + licz]) ;
                }
            }
            er = (er / wyn.Count);
            return er;

        }


    }
}
