using System;
using System.Collections.Generic;
using System.Text;
using Intemi;

namespace ToyMachines
{

    public class TMConfig : IConfiguration
    {
        public void Configure(ConfigBuilder confBuilder)
        {
	        confBuilder.DeclareInput("Input dataset",
	            new Type[] { typeof(IDataTable), typeof(ITargets) }, false);
            confBuilder.DeclareOutput("Classifier",
                new Type[] { typeof(IClassifier) }, false, "ClassSubmachine", null);

            ConfigBase c = confBuilder.project.GetConfiguration("kNN");
            ConfigBase c2 = confBuilder.project.GetConfiguration("Naive Bayesian Classifier");
            confBuilder.Subconfigurations.Add(0, c);
            confBuilder.Subconfigurations.Add(1, c2);

        }
        public object Clone() { return new TMConfig(); }
    }

    [Machine("TM", typeof(TMConfig))]
    public class TM : IMachine
    {
        ImachineBase machineBase;
        IClassifier classSubmachine = null;
        public void SetmachineBase(ImachineBase mb) { machineBase = mb; }

        public IClassifier ClassSubmachine
        {
            get { return classSubmachine; }
        }

        public void Run(ref bool shouldTerminate)
        {
            ConfigBase c = machineBase.ConfBase.Subconfigurations[0];
            c.Inputs.BindParentInput("Input dataset", "Input dataset");
            machineBase.Submachines.Count = 2;
            machineBase.Submachines.Create(0, c);

            ConfigBase c2 = machineBase.ConfBase.Subconfigurations[1];
            c2.Inputs.BindParentInput("Input dataset", "Input dataset");
            machineBase.Submachines.Create(1, c2);

            machineBase.Submachines.WaitAll();

            Random r = new Random();
            classSubmachine = (IClassifier)
                machineBase.Submachines[r.Next(1)].OpenOutput("Classifier");
        }
    }
}
