﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;


namespace Neurall
{
    class Siec
    {
        private Neuron[][] Network;//;//tablica warstw(layer)
        
        private int Layers_num;


        public Neuron[][] network
        {
            get
            {
                return Network;
            }

            set
            {
                Network = value;
            }
        } 




        public Siec(int n, List<int> lneur_in_layer, List<int> lwag_in_layer, int bias, double b,double gamma) //n liczba warstw !,bias =0,1
        {
            Layers_num = n; //+1 dla dodatkowej "pierwszej warst
            Network = new Neuron[Layers_num][];
            if (Layers_num > 1)
            {
                for (int i = 0; i < Layers_num - 1; i++)
                {
                    Network[i] = new Neuron[lneur_in_layer[i]];
                    for (int j = 0; j < lneur_in_layer[i] - 1; j++)
                        Network[i][j] = new Neuron(lwag_in_layer[i], 0, b,gamma);


                    Network[i][lneur_in_layer[i] - 1] = new Neuron(lwag_in_layer[i], bias, b,gamma);
                }

                Network[Layers_num - 1] = new Neuron[lneur_in_layer[Layers_num - 1]];


                for (int j = 0; j < lneur_in_layer[Layers_num - 1] - 1; j++)

                    Network[Layers_num - 1][j] = new Neuron(lwag_in_layer[Layers_num - 1], 0, b,gamma);


                Network[Layers_num - 1][lneur_in_layer[Layers_num - 1] - 1] = new Neuron(lwag_in_layer[Layers_num - 1], bias, b,gamma);
            }
            else
            {
                Network[0] = new Neuron[lneur_in_layer[0]];

                for (int j = 0; j < lneur_in_layer[0] - 1; j++)
                    Network[0][j] = new Neuron(lwag_in_layer[0], 0, b,gamma);
                Network[0][lneur_in_layer[0] - 1] = new Neuron(lwag_in_layer[0], bias, b,gamma);

            }

        }



        public double[] Outputy(double[] inputx, int warstwa, int bias, Func<double, double, double> fun, double lambda,double b)
        {
            double[] y = new double[(int)Network[warstwa].Length];

            if (b != 0)             //DLA DMLP
            {
                if (Network[warstwa].Length > 1)   //DLA WIELU WARSTW /neuronow?
                {
                    for (int i = 0; i < Network[warstwa].Count() - 1; i++)
                    {

                        y[i] = fun(Network[warstwa][i].DNet(inputx), lambda);
                    }
                    if (bias == 0)
                        y[Network[warstwa].Count() - 1] = fun(Network[warstwa][Network[warstwa].Count() - 1].DNet(inputx), lambda);
                    else y[Network[warstwa].Count() - 1] = -1;

                }
                else                 //DLA JEDNEgo neuronu
                {
                    for (int i = 0; i < Network[warstwa].Count(); i++)
                    {

                        y[i] = fun(Network[warstwa][i].DNet(inputx), lambda);
                    }

                }
            }                   //DLA MLP:
            else
            {
                if (Network[warstwa].Length > 1)    //DLA WIELU WARSTW
                {
                    for (int i = 0; i < Network[warstwa].Count() - 1; i++)
                    {

                        y[i] = fun(Network[warstwa][i].Net(inputx), lambda);
                    }
                    if (bias == 0)
                        y[Network[warstwa].Count() - 1] = fun(Network[warstwa][Network[warstwa].Count() - 1].Net(inputx), lambda);
                    else y[Network[warstwa].Count() - 1] = -1;
                }
                else            //DLA JEDNEJ WARSTWY
                {
                    for (int i = 0; i < Network[warstwa].Count(); i++)
                    {

                        y[i] = fun(Network[warstwa][i].Net(inputx), lambda);
                    }

                }

            }
                     
            return y;
        }




       


        public double[] Output(double[] input, Func<double, double, double> fun, double lambda,double b) //generuje sygnał wyjśiowy sieci z danych inputx
        {
            double[] output;
            if (Layers_num == 1)
            {
                output = Outputy(input, 0, 0, fun, lambda, b);//zmienilam bias z 1 na 0
            }
            else
            {
                output = Outputy(input, 0, 1, fun, lambda, b);
            int i = 1;

            
            
                while (i < Layers_num - 1)
                     {


                      double[] tr = Outputy(output, i, 1, fun, lambda,b);
                      output = new double[this.network[i].Length];
                     tr.CopyTo(output, 0);
                     i++;

                    }
                 double[] tr1 = Outputy(output, Layers_num - 1, 0, fun, lambda,b);
                 output = new double[this.network[Layers_num - 1].Length];
                 tr1.CopyTo(output, 0);
            }

            return output;
        }





        public void LearnAll(List<List<double>> Ar, int[][] D, RichTextBox text1, Func<double, double, double> fun, Func<double, double, double> pochodna, List<double> Ee, double lambda, double a, double b,double gamma,bool zn,double minn,int it) //a wspól uczenia
        {
            //double eold=0;
            double e ;
            int j = 0;
           // double err;
            
            for (int jj = 0; jj < Network.Length; jj++)
            {

                double[][] dw = new double[network[0].Length][];
                for (int i = 0; i < network[0].Length; i++)
                    dw[i] = new double[Ar[0].Count];
            }
            if (b != 0)
            {


                    while (j <it) 
                {
                    List<List<double>> ls=new List<List<double>>();
                    int[][] ds=new int [D.Length][];
                    ls.AddRange(Ar);
                    for (int k = 0; k < D.Length; k++)
                    {
                        ds[k]=new int[D[0].Length];
                        D[k].CopyTo(ds[k], 0);

                    }
                    Input.Randd(ls, ds,j);
                    j++;
                    e = 0;

                    for (int i = 0; i < ls.Count; i++)
                    {
                        double[] ar = new double[ls[0].Count];
                        ls[i].CopyTo(ar);

                        learnDIST(ds[i], ar, a, text1, fun, pochodna, lambda, b);
                         e += E(ds[i], ar, fun, lambda, b);


                    }
                    
                     if (j == 210 && e > 100) break;
                   //  if (j == 500 && e > 300) break;
                    
                    // }

                     /*if (e > (1.001 * eold))
                        a = 0.5 * a;
                    else
                        if (e < 1.005*eold)
                            a = a+0.009*a;

                         eold = e; /*/
                        if(zn)
                      text1.AppendText(e.ToString() + "\n");
                     Ee.Add(e);
                     if (j == 2 && Ee[0] == Ee[1]) break;
                     if (e < minn)
                         break;
                    /*  if (j == 250)
                     {
                          if (e > Ee[0] - 100)
                              break;
                     }*/
                }
            }
            else
            {
                while (j < it) 
                {

                    List<List<double>> ls = new List<List<double>>();
                    int[][] ds = new int[D.Length][];
                    ls.AddRange(Ar);
                    for (int k = 0; k < D.Length; k++)
                    {
                        ds[k] = new int[D[0].Length];
                        D[k].CopyTo(ds[k], 0);

                    }
                    Input.Randd(ls, ds,j);
                    j++;
                    e = 0;
                  
                    //for (int j = 0; j < D[0].Length;j++ )
                    
                        for (int i = 0; i < ls.Count; i++)
                        {
                            double[] ar = new double[ls[0].Count];
                            ls[i].CopyTo(ar);

                            learn(ds[i], ar, a, text1, fun, pochodna, lambda, b);
                            e += E(ds[i], ar, fun, lambda, b);
                           

                        }
                        // if (j == 70 && e > 600) break;
                          
                         if (e < minn) break;
                      /*  if (j == 300)
                         {
                            if (e > 200)
                                 break;
                         } */
                         if (zn)
                       text1.AppendText(e.ToString() +  "\n");
                        Ee.Add(e);
                        if (j == 2 && Ee[0] == Ee[1]) break;
                }
            }

       }




        public void do_Pl(int[][] D, List<List<double>> Ar, List<List<double>> wyn, Func<double, double, double> fun, double lambda, double b)
        {

            for (int i = 0; i < Ar.Count; i++)
            {
                double[] ar = new double[Ar[0].Count];
                Ar[i].CopyTo(ar);
                double[] y;
                y = Output(ar, fun, lambda, b);
                List<double> l = new List<double>();
                for (int j = 0; j < D[i].Length; j++)
                     l.Add(y[j]);
                   
                
                for (int j = 0; j < D[i].Length; j++)
                      l.Add(D[i][j]);  
                                     
                         
                wyn.Add(l);
              }

        }

        public void wynn(int[][] D, List<List<double>> Ar, List<List<double>> wyn, Func<double, double, double> fun, double lambda, double b)
        {

            for (int i = 0; i < Ar.Count; i++)
            {
                 double zn = 0;
                double[] ar = new double[Ar[0].Count];
                Ar[i].CopyTo(ar);
                double[] y;
                y = Output(ar, fun, lambda, b);
                List<double> l = new List<double>();
                for (int j = 0; j < Ar[i].Count-1; j++)
                l.Add(Ar[i][j]);
                for (int j = 0; j < D[i].Length; j++)
                {
                    if (y[j] >= 0.5)
                        zn = 1;
                }
                 l.Add(zn);
                
                    wyn.Add(l);
            }

        }








        public double E(int[] d, double[] inputx, Func<double, double, double> fun, double lambda, double b )
        {
            double e1 = 0;
            double[] y;
            y = Output(inputx, fun, lambda, b);
            for (int i = 0; i < y.Length; i++)
            {
                e1 += (y[i] - d[i]) * (y[i] - d[i]);
            }
            return e1 / 2;
        }

      
        
        public void learn(int[] d, double[] inputx, double a, RichTextBox text, Func<double, double, double> fun, Func<double, double, double> pochodna, double lambda,double b) //a współczynnik uczenia
        {
            if (Layers_num > 1)
            {

                double[] F_y = new double[network[network.Length - 1].Length];
                double[][] Y = new double[network.Length][];
                double add = 0;
                int kk = 0;


                double[][] delta = new double[network.Length][];
                Y[0] = Outputy(inputx, 0, 1, fun, lambda, b);
                delta[0] = new double[network[0].Length];
                for (int i = 1; i < network.Length - 1; i++)
                {
                    delta[i] = new double[network[i].Length];
                    Y[i] = Outputy(Y[i - 1], i, 1, fun, lambda, b);
                }
                delta[network.Length - 1] = new double[network[network.Length - 1].Length];
                Y[network.Length - 1] = Outputy(Y[network.Length - 2], network.Length - 1, 0, fun, lambda, b);


                for (int i = 0; i < d.Length; i++)
                {
                    F_y[i] = Y[network.Length - 1][i] - d[i];
                }


                for (int j = 0; j < network[network.Length - 1].Length; j++)
                    delta[network.Length - 1][j] = F_y[j] * pochodna(Network[network.Length - 1][j].Net(Y[network.Length - 2]), lambda);


                for (int i = network.Length - 2; i > 0; i--)
                {
                    for (int j = 0; j < network[i].Length; j++)
                    {
                        for (int k = 0; k < network[i + 1].Length; k++)
                        {
                            add += delta[i + 1][k] * network[i + 1][k].W[j];
                        }
                        delta[i][j] = pochodna(Network[i][j].Net(Y[i - 1]), lambda) * add; 
                        add = 0;
                    }
                }

                for (int j = 0; j < network[0].Length; j++)
                {
                    for (int k = 0; k < network[0 + 1].Length; k++)
                    {
                        add += delta[0 + 1][k] * network[0 + 1][k].W[j];
                    }
                    delta[0][j] = pochodna(Network[0][j].Net(inputx), lambda) * add;
                    add = 0;
                }


                for (int j = 0; j < network[0].Length; j++)
                {
                    for (int k = 0; k < inputx.Length; k++)
                    {
                        network[0][j].W[k] -= a * delta[0][j] * inputx[k];


                    }
                    kk++;
                }

                for (int i = 1; i < network.Length; i++)
                {

                    for (int j = 0; j < network[i].Length; j++)
                    {
                        for (int k = 0; k < network[i - 1].Length; k++)
                        {
                            network[i][j].W[k] -= a * delta[i][j] * Y[i - 1][k];

                        }
                    }
                }
            }
            else
            {
                double[] F_y = new double[network[0].Length];
                double[] Y = new double[network[0].Length];
                int kk = 0;
                double[] delta = new double[network[0].Length];


                Y = Outputy(inputx, 0, 0, fun, lambda,b);


                for (int i = 0; i < d.Length; i++)
                {
                    F_y[i] = Y[i] - d[i];
                }


                for (int j = 0; j < network[0].Length; j++)
                    delta[j] = F_y[j] * pochodna(Network[0][j].Net(inputx), lambda);



                for (int j = 0; j < network[0].Length; j++)
                {
                    for (int k = 0; k < inputx.Length; k++)
                    {

                        network[0][j].W[k] -= a * delta[j] * inputx[k];
                     

                    }
                    kk++;
                }

            }

        }





        public void learnDIST(int[] d, double[] inputx, double a, RichTextBox text, Func<double, double, double> fun, Func<double, double,  double> pochodna, double lambda, double b) //a współczynnik uczenia
        {

            if (Layers_num > 1)
            {


                double[] F_y = new double[network[network.Length - 1].Length];
                double[][] Y = new double[network.Length][];
                double add = 0;
                int kk = 0;
            
                double[][] delta = new double[network.Length][];
                Y[0] = Outputy(inputx, 0, 1, fun, lambda, b);
                delta[0] = new double[network[0].Length];
                for (int i = 1; i < network.Length - 1; i++)
                {
                    delta[i] = new double[network[i].Length];
                    Y[i] = Outputy(Y[i - 1], i, 1, fun, lambda, b);
                }
                delta[network.Length - 1] = new double[network[network.Length - 1].Length];
                Y[network.Length - 1] = Outputy(Y[network.Length - 2], network.Length - 1, 0, fun, lambda, b);


                for (int i = 0; i < d.Length; i++)
                {
                    F_y[i] = Y[network.Length - 1][i] - d[i];
                }


                for (int j = 0; j < network[network.Length - 1].Length; j++)
                    delta[network.Length - 1][j] = F_y[j] * pochodna(Network[network.Length - 1][j].DNet(Y[network.Length - 2]), lambda);


                for (int i = network.Length - 2; i > 0; i--)
                {
                    
                        
                            for (int j = 0; j < network[i].Length; j++)
                            {
                                for (int k = 0; k < network[i + 1].Length; k++)
                                {
                                    add += delta[i + 1][k] * network[i + 1][k].W[j];
                                    if(j==0)
                                    add += delta[i + 1][k] * network[i + 1][k].b;
                                }

                        delta[i][j] = pochodna(Network[i][j].DNet(Y[i - 1]), lambda) * add;
                        add = 0;
                    }
                }

               
                    
                        for (int j = 0; j < network[0].Length; j++)
                        {
                            for (int k = 0; k < network[0 + 1].Length; k++)
                            {
                        add += delta[0 + 1][k] * network[0 + 1][k].W[j];
                                if(j==0)
                        add += delta[0 + 1][k] * network[0 + 1][k].b;
                        
                            }
                        

                    delta[0][j] = pochodna(Network[0][j].DNet(inputx), lambda) * add;
                    add = 0;
                }


                for (int j = 0; j < network[0].Length; j++)
                {
                    for (int k = 0; k < inputx.Length; k++)
                    {


                        network[0][j].W[k] -= a * delta[0][j] * Network[0][j].pochCzesc(inputx, k);
                       
                    }
                    network[0][j].b -= 1   *a * delta[0][j] * Network[0][j].pochB(inputx);
                    network[0][j].gamma -= 1* a * delta[0][j] * Network[0][j].pochGam(inputx);
                     if (network[0][j].gamma < 0.000001 && network[0][j].gamma > -0.000001)
                         network[0][j].gamma -= 0.1;
                    
                  
                    kk++;
                }
          
                for (int i = 1; i < network.Length; i++)
                {

                    for (int j = 0; j < network[i].Length; j++)
                    {
                        for (int k = 0; k < network[i - 1].Length; k++)
                        {


                            network[i][j].W[k] -= a * delta[i][j] * Network[i][j].pochCzesc(Y[i - 1], k);

                        }
                        network[i][j].b -= 1 * a * delta[i][j] * Network[i][j].pochB(Y[i - 1]);
                        network[i][j].gamma -= 1 * a * delta[i][j] * Network[i][j].pochGam(Y[i - 1]);
                        if (network[i][j].gamma < 0.000001 && network[0][j].gamma > -0.000001)
                            network[i][j].gamma -= 0.1;
                        
                        
                       
                    }
                }
            }
            else
            {
                double[] F_y = new double[network[0].Length];
                double[] Y = new double[network[0].Length];
                int kk = 0;
                double[] delta = new double[network[0].Length];
               
                Y = Outputy(inputx, 0, 0, fun, lambda, b); //zmiana baisasu z 1 na 0 poprawic!


                for (int i = 0; i < d.Length; i++)
                {
                    F_y[i] = Y[i] - d[i];
                }


                for (int j = 0; j < network[0].Length; j++)
                    delta[j] = F_y[j] * pochodna(Network[0][j].DNet(inputx), lambda);
                for (int j = 0; j < network[0].Length; j++)
                {
                    for (int k = 0; k < inputx.Length; k++)
                    {


                        network[0][j].W[k] -= a * delta[j] * Network[0][j].pochCzesc(inputx, k); 
                      
                    }
                    double ff = Network[0][j].pochB(inputx);
                    double ss = Network[0][j].pochGam(inputx);
                    network[0][j].b -= 1 * a * delta[j] * Network[0][j].pochB(inputx);
                      network[0][j].gamma -= 1* a * delta[j] * Network[0][j].pochGam(inputx);
                      if (network[0][j].gamma < 0.000001 && network[0][j].gamma>-0.000001)
                          network[0][j].gamma -= 0.1;
                       
                    kk++;
                }
            }

        }



       







     




    }
}
